﻿using log4net;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Net;
using System.Threading.Tasks;
using VA.PPMS.IWS.Api.Configuration.Interface;
using VA.PPMS.IWS.Api.HttpClientHandler.Interface;

namespace VA.PPMS.IWS.Api.Controllers
{
    [Route("Binary/[controller]/v1")]
    public class PpmsDataStreamController : Controller
    {
        private readonly ILog _logger;
        private readonly IIwsConfiguration _configuration;
        private readonly IHttpClientHandler _client;

        public PpmsDataStreamController(ILog logger, IIwsConfiguration configuration, IHttpClientHandler client)
        {
            _logger = logger;
            _configuration = configuration;
            _client = client;
        }

        [HttpGet("{id}")]
        public async Task<IActionResult> Get(string id, string transactionId, string requestor, string purposeOfUse, string dataSource)
        {
            try
            {
                _logger.Info("@@@@@ Info - Start GET for PpmsDataStreamController @@@@@");

                var ppmsDataStreamUri = await _configuration.GetPpmsDataStreamUri();
                var queryString = $"{ppmsDataStreamUri}?id={id}&transactionId={transactionId}&requestor={requestor}&purposeOfUse={purposeOfUse}&dataSource={dataSource}";

                using (var response = await _client.GetAsync(queryString))
                {
                    if (response.IsSuccessStatusCode)
                    {
                        var returnStatus = await response.Content.ReadAsStringAsync();
                        _logger.Info("@@@@@ Info - End GET for PpmsDataStreamController @@@@@");
                        return StatusCode(StatusCodes.Status200OK, returnStatus);
                    }

                    _logger.Error($"PpmsDataStreamController: Error calling PpmsDataStream Api. Bad Status Returned: {response.StatusCode}");
                    var error = await response.Content.ReadAsStringAsync();
                    _logger.Error($"PpmsDataStreamController GET Exception. The error is {error}: {response}");

                    return StatusCode(response.StatusCode == HttpStatusCode.ExpectationFailed ? StatusCodes.Status424FailedDependency : StatusCodes.Status412PreconditionFailed);
                }
            }
            catch (Exception ex)
            {
                _logger.Error("PpmsDataStreamController GET Exception:", ex);
                return StatusCode(StatusCodes.Status500InternalServerError, ex.Message);
            }
        }
    }
}